import logging
from datetime import datetime
import os, sys
import subprocess
import BackhaulConfiguration

class LevelFilter(logging.Filter):
    def __init__(self, low, high):
        self._low = low
        self._high = high
        logging.Filter.__init__(self)
    def filter(self, record):
        if self._low <= record.levelno <= self._high:
            return True
        return False

datetime = ('{:%Y-%m-%d}'.format(datetime.now()))

logpath = BackhaulConfiguration.getLogDirectory()

# setup the logging configuration
logging.basicConfig(format='%(asctime)s:::%(levelname)s:::isupload=0:::%(message)s', level=logging.DEBUG)
formatter = logging.Formatter('%(asctime)s:::%(levelname)s:::isupload=0:::%(message)s', "%Y-%m-%d %H:%M:%S")
log = logging.getLogger('MainLogger')
# declare handler for each level logging
critical_handler = logging.FileHandler(logpath + str(datetime)  + '_critical.log', 'a')
critical_handler.addFilter(LevelFilter(50, 50))
critical_handler.setFormatter(formatter)
error_handler = logging.FileHandler(logpath + str(datetime)  + '_error.log', 'a')
error_handler.addFilter(LevelFilter(40, 40))
error_handler.setFormatter(formatter)
warn_handler = logging.FileHandler(logpath + str(datetime)  + '_warn.log', 'a')
warn_handler.addFilter(LevelFilter(30, 30))
warn_handler.setFormatter(formatter)
info_handler = logging.FileHandler(logpath + str(datetime)  + '_info.log', 'a')
info_handler.addFilter(LevelFilter(20, 20))
info_handler.setFormatter(formatter)
debug_handler = logging.FileHandler(logpath + str(datetime)  + '_debug.log', 'a')
debug_handler.addFilter(LevelFilter(10, 10))
debug_handler.setFormatter(formatter)
log.addHandler(error_handler)
log.addHandler(warn_handler)
log.addHandler(critical_handler)
log.addHandler(info_handler)
log.addHandler(debug_handler)

# Stop pika from spamming the debug command line
logging.getLogger("pika").setLevel(logging.WARNING)
